/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOACP_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO ACP
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file PNIOACP_Functionlist.h
 * @brief PNIO ACP - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOACP</code>
 * of task.
 */
#ifndef __PNM_PNIO_ACP_FUNCTIONLIST_H
#define __PNM_PNIO_ACP_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIOACP
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIOACP
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_ACP_STARTUP_PARAM_VERSION_2 (2)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNM_PNIO_ACP_STARTUPPARAMETER_Ttag  PNM_PNIO_ACP_STARTUPPARAMETER_V2_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNM_PNIO_ACP_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** EDD name
   *
   * The member defines the name of Ethernet device driver, which
   * handles the access to an Ethernet port.
   */
  TLR_INT8*   pszName;

  /** minimum send clock factor
   *
   * The member defines the send clock factor to set the basic cycle time of
   * PROFINET IO-Scheduling. According to the specification the factor 32 means
   * a cycle time of 1ms.
   */
  TLR_UINT    uiScFact;

  /** maximum reduction ratio
   *
   * The member defines the maximum reduction ratio of PROFINET IO-Scheduling.
   * According to the specification the reduction ratio 512 means
   * a cycle time of 512ms by using the send clock factor 32.
   */
  TLR_UINT    uiMaxRatio;

  /** maximum frame of phase
   *
   * The member defines the maximum frames, which can
   * be handled inside of a phase to send or receive real-time frames cyclic.
   */
  TLR_UINT    uiMaxFrame;

  /** maximum consumer protocol machine
   *
   * The member defines the maximum number of consumer protocol machines.
   */
  TLR_UINT    uiMaxCpm;

  /** maximum provider protocol machine
   *
   * The member defines the maximum number of provider protocol machines.
   */
  TLR_UINT    uiMaxPpm;

  /** maximum alarm protocol machine
   *
   * The member defines the maximum number of alarm protocol machines.
   */
  TLR_UINT    uiMaxAlpm;

  /** EDD instance
   *
   * The member defines the instance of Ethernet device driver.
   */
  TLR_UINT    uiEddInstance;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNM_PNIO_ACP_FUNCTIONLIST_H */
